<?php
/*
 * This file tends to be included in any development.
 * In a sentence, in every case where you don't want to use WP-LESS as a standalone.
 *
 * Once included, it's up to you to use the available toolkit for your needs.
 *
 * = How to use? =
 *
 * 1. In your theme, include the `wp-less` anywhere you want. (eg: `wp-content/themes/yourtheme/lib/wp-less`)
 * 2. Include the required files in your functions.php file. (eg: `require dirname(__FILE__).'/lib/wp-less/bootstreap-theme.php`)
 * 3. The `$WPLessPlugin` is available for your
 *
 * In case you need to access the $WPLessPlugin variable outside the include scope, simply do that:
 * `$WPLessPlugin = WPLessPlugin::getInstance();`
 *
 * And to apply automatic building on page display:
 * `add_action('wp_print_styles', array($WPLessPlugin, 'processStylesheets'));`
 * Or apply all hooks with:
 * `$WPLessPlugin->dispatch();`
 *
 * You can rebuild all stylesheets at any time with:
 * `$WPLessPlugin->processStylesheets();`
 *
 * Or a specific stylesheet:
 * `wp_enqueue_style('my_css', 'path/to/my/style.css');`
 * `$WPLessPlugin->processStylesheet('my_css');`
 *
 * = Filters and hooks aren't enough =
 *
 * Build your own flavour and manage it the way you want. Simply extends WPLessPlugin and/or WPLessConfiguration.
 * Dig in the code to see what to configure. I tried to make things customizable without extending classes!
 */

/*
 * This will be effective only if the plugin is not activated.
 * You can then redistribute your theme with this loader fearlessly.
 */
if (!class_exists('WPLessPlugin')) {

	require dirname(__FILE__).'/lib/Plugin.class.php';
	$WPLessPlugin = WPPluginToolkitPlugin::create('WPLess', __FILE__, 'WPLessPlugin');

	// TODO: Start garbage collection after the theme settings saved.

	//READY and WORKING
	// add_action('after_setup_theme', array($WPLessPlugin, 'install'));

	// NOT WORKING
	//@see http://core.trac.wordpress.org/ticket/14955
	// add_action('uninstall_theme', array($WPLessPlugin, 'uninstall'));
}
